/**@@@+++@@@@******************************************************************
**
** Microsoft Windows Media
** Copyright (C) Microsoft Corporation. All rights reserved.
**
***@@@---@@@@******************************************************************
*/

#ifndef __DRM_RC4_H__
#define __DRM_RC4_H__

#include <drmcommon.h>
#ifdef DX_WMDRM_USE_CRYS
#include "CRYS.h"
#endif
#if DRM_USE_RSA_IMPL
#include <rc4.h>

#define DRM_RC4_KeySetup(ks,cb,pb) rc4_key((ks),(cb),(pb))
#define DRM_RC4_Cipher(ks,cb,pb) rc4((ks),(cb),(pb))


#else /* DRM_USE_RSA_IMPL */


#ifdef __cplusplus
extern "C" {
#endif

#define RC4_TABLESIZE 256

#ifndef DX_WMDRM_USE_CRYS
/* Key structure */
typedef struct __tagRC4_KEYSTRUCT
{
	DRM_BYTE S[__CB_DECL(RC4_TABLESIZE)];     /* State table */
	DRM_BYTE i, j;        /* Indices */
} RC4_KEYSTRUCT;
#else
#define DRM_RC4_SW		0x0
#define DRM_RC4_HW		0x1
typedef struct __tagRC4_KEYSTRUCT
{
	DRM_UINT rc4Type;
	union{
		struct{
				DRM_BYTE S[__CB_DECL(RC4_TABLESIZE)];     /* State table */
				DRM_BYTE i, j;        /* Indices */
			   }rc4Sw;
		CRYS_RC4UserContext_t rc4Hw;
	     }rc4CTX;
} RC4_KEYSTRUCT;
#endif
/*********************************************************************
**
**  Function:  DRM_RC4_KeySetup
**
**  Synopsis:  Generate the key control structure.  Key can be any size.
**
**  Arguments:  
**     [pKS] -- A KEYSTRUCT structure that will be initialized.
**     [cbKey] -- Size of the key, in bytes.
**     [pbKey] -- Pointer to the key.
**
**  Returns:  None
**
*********************************************************************/

DRM_VOID DRM_API DRM_RC4_KeySetup(
    OUT       RC4_KEYSTRUCT  *pKS,
    IN        DRM_DWORD       cbKey,
    IN  const DRM_BYTE       *pbKey );

/*********************************************************************
**
**  Function:  DRM_RC4_Cipher
**
**  Synopsis:  
**
**  Arguments:  
**     [pKS] -- Pointer to the KEYSTRUCT created using DRM_RC4_KeySetup.
**     [cbBuffer] -- Size of buffer, in bytes.
**     [pbBuffer] -- Buffer to be encrypted in place.
**
**  Returns:  None
*********************************************************************/

DRM_VOID DRM_API DRM_RC4_Cipher(
    IN OUT RC4_KEYSTRUCT *pKS,
    IN     DRM_UINT       cbBuffer,
    IN OUT DRM_BYTE      *pbBuffer );

#ifdef __cplusplus
}
#endif

#endif /* DRM_USE_RSA_IMPL */

#endif /* __DRM_RC4_H__ */
